
#include "rgb.h"

void rainbow(rgb* pRGB, unsigned char pos) {
    if( pos <= 42 || pos >= 213 ) {
      pRGB->r = 255;
    } else if( pos < 85 ) {
      pRGB->r = (85 - pos)*2 + (85 - pos)*4;
    } else if( pos >= 170 ) {
      pRGB->r = (pos - 170)*2 + (pos - 170)*4;
    } else {
      pRGB->r = 0;
    }
  
    pos = (pos + 255 - 85) & 255;
  
    if( pos <= 42 || pos >= 213 ) {
      pRGB->g = 255;
    } else if( pos < 85 ) {
      pRGB->g = (85 - pos)*2 + (85 - pos)*4;
    } else if( pos >= 170 ) {
      pRGB->g = (pos - 170)*2 + (pos - 170)*4;
    } else {
      pRGB->g = 0;
    }
  
    pos = (pos + 255 - 84) & 255;
  
    if( pos <= 42 || pos >= 213 ) {
      pRGB->b = 255;
    } else if( pos < 85 ) {
      pRGB->b = (85 - pos)*2 + (85 - pos)*4;
    } else if( pos >= 170 ) {
      pRGB->b = (pos - 170)*2 + (pos - 170)*4;
    } else {
      pRGB->b = 0;
    }
}

void xmas(rgb* pRGB, unsigned char pos) {
    if( pos <= 42 ) {
      pRGB->r = (42-pos)*6;
      pRGB->g = 0;
      pRGB->b = 0;
    } else if( pos > 213 ) {
      pRGB->r = (pos-213)*6;
      pRGB->g = 0;
      pRGB->b = 0;
    }
  
    pos = (pos + 255 - 85) & 255;
  
    if( pos <= 42 ) {
      pRGB->r = 0;
      pRGB->g = (42-pos)*6;
      pRGB->b = 0;
    } else if( pos > 213 ) {
      pRGB->r = 0;
      pRGB->g = (pos-213)*6;
      pRGB->b = 0;
    }
  
    pos = (pos + 255 - 84) & 255;
  
    if( pos <= 42 ) {
      pRGB->r = pRGB->g = pRGB->b = (42-pos)*6;
    } else if( pos > 213 ) {
      pRGB->r = pRGB->g = pRGB->b = (pos-213)*6;
    }
}

void ice(rgb* pRGB, unsigned char pos) {
    if( pos < 64 ) {
      pRGB->r = pRGB->g = (63-pos)*4;
      pRGB->b = 255;
    } else if( pos < 128 ) {
      pRGB->r = 0;
      pRGB->g = (pos-64)*4;
      pRGB->b = 255;
    } else if( pos < 192 ) {
      pRGB->r = 0;
      pRGB->g = (191-pos)*4;
      pRGB->b = 255;
    } else {
      pRGB->r = pRGB->g = (pos-192)*4;
      pRGB->b = 255;
    }
}

void xmas2(rgb* pRGB, unsigned char pos) {
    if( pos < 64 ) {
      pRGB->r = (63-pos)*4;
      pRGB->g = (pos)*4;
      pRGB->b = 0;
    } else if( pos < 128 ) {
      pRGB->r = pRGB->b = (pos-64)*4;
      pRGB->g = 255;
    } else if( pos < 192 ) {
      pRGB->r = pRGB->g = pRGB->b = (191-pos)*4;
    } else {
      pRGB->r = (pos-192)*4;
    }
}

void colourScheme(rgb* pRGB, unsigned char scheme, unsigned char pos) {
    switch(scheme) {
      case 1:
        rainbow(pRGB, pos);
        break;
      case 2:
        xmas(pRGB, pos);
        break;
      case 3:
        ice(pRGB, pos);
        break;
      case 4:
        xmas2(pRGB, pos);
        break;
    }
}

#if 0
void rainbowBright(rgb* pRGB, unsigned char pos, unsigned char bright) {
    rainbow(pRGB, pos);
    pRGB->r = bright + pRGB->r * (256 - bright) / 256;
    pRGB->g = bright + pRGB->g * (256 - bright) / 256;
    pRGB->b = bright + pRGB->b * (256 - bright) / 256;
}
#endif

void xmasBright(rgb* pRGB, unsigned char pos, unsigned char bright) {
    if( pos < 42 || pos > 256-42 )
      pos = 0;
    else if( pos < 85+42 )
      pos = 85;
    else
      pos = 85*2;
    xmas(pRGB, pos);
    pRGB->r = bright + pRGB->r * (256 - bright) / 256;
    pRGB->g = bright + pRGB->g * (256 - bright) / 256;
    pRGB->b = bright + pRGB->b * (256 - bright) / 256;
}

void schemeBright(rgb* pRGB, unsigned char scheme, unsigned char pos, unsigned char bright) {
    colourScheme(pRGB, scheme, pos);
    pRGB->r = bright + pRGB->r * (256 - bright) / 256;
    pRGB->g = bright + pRGB->g * (256 - bright) / 256;
    pRGB->b = bright + pRGB->b * (256 - bright) / 256;
}

void colourSchemeBright(rgb* pRGB, unsigned char scheme, unsigned char pos, unsigned char bright) {
    switch(scheme) {
      case 1:
      case 3:
      case 4:
        schemeBright(pRGB, scheme, pos, bright);
        break;
      case 2:
        xmasBright(pRGB, pos, bright);
        break;
    }
}
